/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.core.builder;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.IUniformResource;
import com.aptana.core.resources.MarkerUtils;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.editor.php.internal.core.builder.Messages;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org2.eclipse.dltk.compiler.problem.CategorizedProblem;
import org2.eclipse.dltk.compiler.problem.IProblem;
import org2.eclipse.dltk.compiler.problem.ProblemCollector;

public class BuildProblemReporter
extends ProblemCollector {
    private final Object resource;
    private boolean oldMarkersDeleted = false;
    private boolean isExternal;
    private String resourceLocation;

    public BuildProblemReporter(Object resource) {
        this.isExternal = resource instanceof IUniformResource;
        if (!this.isExternal && !(resource instanceof IResource)) {
            throw new IllegalArgumentException("The given resource is expected to be an IResource or an IUniformResource");
        }
        this.resource = resource;
        this.resourceLocation = "";
    }

    private static ISchedulingRule getMarkerRule(Object resource) {
        if (resource instanceof IResource) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().markerRule((IResource)resource);
        }
        return null;
    }

    public void flush() {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                BuildProblemReporter.this.updateMarkers();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, BuildProblemReporter.getMarkerRule(this.resource), 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)PHPEplPlugin.getDefault(), (String)MessageFormat.format(Messages.BuildProblemReporter_UpdateMarkersError, this.resourceLocation), (Throwable)e, (String)"com.aptana.editor.php.epl/debug");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateMarkers() {
        try {
            block25: {
                if (EclipseUtil.isTesting()) {
                    return;
                }
                workspaceResource = null;
                externalResource = null;
                if (!this.isExternal) break block25;
                externalResource = (IUniformResource)this.resource;
                uri = externalResource.getURI();
                if (uri != null) {
                    this.resourceLocation = uri.getPath();
                }
                ** GOTO lbl19
            }
            workspaceResource = (IResource)this.resource;
            if (workspaceResource == null || !workspaceResource.isAccessible()) {
                IdeLog.logWarning((Plugin)PHPEplPlugin.getDefault(), (String)"BuildProblemReporter::flush -> Unexpected null or non-accessible resource");
                return;
            }
            try {
                this.resourceLocation = workspaceResource.getLocation().toString();
lbl19:
                // 2 sources

                if (!this.oldMarkersDeleted) {
                    this.oldMarkersDeleted = true;
                    if (this.isExternal) {
                        MarkerUtils.deleteMarkers((IUniformResource)externalResource, (String)"com.aptana.editor.php.epl.problem", (boolean)true);
                        MarkerUtils.deleteMarkers((IUniformResource)externalResource, (String)"com.aptana.editor.php.epl.task", (boolean)true);
                    } else {
                        workspaceResource.deleteMarkers("com.aptana.editor.php.epl.problem", true, 2);
                        workspaceResource.deleteMarkers("com.aptana.editor.php.epl.task", true, 2);
                    }
                }
                for (IProblem problem : this.problems) {
                    markerType = problem instanceof CategorizedProblem != false ? ((CategorizedProblem)problem).getMarkerType() : "com.aptana.editor.php.epl.problem";
                    m = null;
                    if (this.isExternal) {
                        m = MarkerUtils.createMarker((IUniformResource)externalResource, null, (String)markerType);
                        m.setAttribute("transient", true);
                    } else {
                        m = workspaceResource.createMarker(markerType);
                    }
                    if (m == null || !m.exists()) {
                        IdeLog.logError((Plugin)PHPEplPlugin.getDefault(), (String)"Error creating a PHP marker", (String)"com.aptana.editor.php.epl/debug");
                    }
                    if (problem.getSourceLineNumber() >= 0) {
                        m.setAttribute("lineNumber", problem.getSourceLineNumber() + 1);
                    }
                    m.setAttribute("message", (Object)problem.getMessage());
                    if (problem.getSourceStart() >= 0) {
                        m.setAttribute("charStart", problem.getSourceStart());
                    }
                    if (problem.getSourceEnd() >= 0) {
                        m.setAttribute("charEnd", problem.getSourceEnd());
                    }
                    if ("com.aptana.editor.php.epl.problem".equals(markerType)) {
                        severity = 0;
                        if (problem.isError()) {
                            severity = 2;
                        } else if (problem.isWarning()) {
                            severity = 1;
                        }
                        m.setAttribute("severity", severity);
                        continue;
                    }
                    m.setAttribute("userEditable", (Object)Boolean.FALSE);
                    if (!(problem instanceof ProblemCollector.TaskInfo)) continue;
                    m.setAttribute("priority", ((ProblemCollector.TaskInfo)problem).getPriority());
                }
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)PHPEplPlugin.getDefault(), (String)MessageFormat.format(Messages.BuildProblemReporter_UpdateMarkersError, new Object[]{this.resourceLocation}), (Throwable)e, (String)"com.aptana.editor.php.epl/debug");
            }
        }
        finally {
            this.problems.clear();
        }
    }
}

